/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldServer;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.controllers.data.TransportCategory;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.dimensions.DimensionHandler;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleTransporter;

public class TransportController {
    private static TransportController instance;
    public Map<Integer, TransportCategory> categories = new TreeMap<Integer, TransportCategory>();
    public List<Integer> worldIDs = new ArrayList<Integer>();
    private int lastUsedID = 0;
    private final Map<Integer, TransportLocation> locations = new TreeMap<Integer, TransportLocation>();

    public static TransportController getInstance() {
        if (instance == null) {
            instance = new TransportController();
        }
        return instance;
    }

    public TransportController() {
        instance = this;
        instance.loadCategories();
        TransportCategory cat = new TransportCategory();
        cat.id = 1;
        cat.title = "Default";
        this.categories.put(cat.id, cat);
    }

    public boolean containsLocationName(String name) {
        name = name.toLowerCase();
        for (TransportLocation loc : this.locations.values()) {
            if (!loc.name.toLowerCase().equals(name)) continue;
            return true;
        }
        return false;
    }

    public NBTTagCompound getNBT() {
        NBTTagList list = new NBTTagList();
        for (TransportCategory category : this.categories.values()) {
            NBTTagCompound compound = new NBTTagCompound();
            category.writeNBT(compound);
            list.func_74742_a((NBTBase)compound);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("lastID", this.lastUsedID);
        nbttagcompound.func_74782_a("NPCTransportCategories", (NBTBase)list);
        Collection<Integer> set = DimensionHandler.getInstance().getMapDimensionsIDs().values();
        int[] ws = new int[set.size()];
        int i = 0;
        Iterator<Integer> iterator = set.iterator();
        while (iterator.hasNext()) {
            int id;
            ws[i] = id = iterator.next().intValue();
            ++i;
        }
        nbttagcompound.func_74783_a("WorldIDs", ws);
        return nbttagcompound;
    }

    public TransportLocation getTransport(int transportId) {
        return this.locations.get(transportId);
    }

    private int getUniqueIdCategory() {
        int id = 0;
        for (int catId : this.categories.keySet()) {
            if (catId <= id) continue;
            id = catId;
        }
        return ++id;
    }

    private int getUniqueIdLocation() {
        if (this.lastUsedID == 0) {
            for (int catId : this.locations.keySet()) {
                if (catId <= this.lastUsedID) continue;
                this.lastUsedID = catId;
            }
        }
        return ++this.lastUsedID;
    }

    private void loadCategories() {
        CustomNpcs.debugData.start(null);
        File saveDir = CustomNpcs.getWorldSaveDirectory();
        if (saveDir == null) {
            CustomNpcs.debugData.end(null);
            return;
        }
        try {
            File file = new File(saveDir, "transport.dat");
            if (!file.exists()) {
                CustomNpcs.debugData.end(null);
                return;
            }
            this.loadCategories(file);
        }
        catch (IOException e) {
            try {
                File file2 = new File(saveDir, "transport.dat_old");
                if (!file2.exists()) {
                    CustomNpcs.debugData.end(null);
                    return;
                }
                this.loadCategories(file2);
            }
            catch (IOException ex) {
                LogWriter.error(e);
            }
        }
        CustomNpcs.debugData.end(null);
    }

    public void loadCategories(File file) throws IOException {
        try {
            this.loadCategories(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0])));
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    public void loadCategories(NBTTagCompound compound) {
        this.locations.clear();
        this.categories.clear();
        this.lastUsedID = compound.func_74762_e("lastID");
        NBTTagList list = compound.func_150295_c("NPCTransportCategories", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            TransportCategory category = new TransportCategory();
            category.readNBT(list.func_150305_b(i));
            for (TransportLocation location : category.locations.values()) {
                this.locations.put(location.id, location);
            }
            this.categories.put(category.id, category);
        }
        if (compound.func_150297_b("WorldIDs", 11)) {
            this.worldIDs.clear();
            for (int id : compound.func_74759_k("WorldIDs")) {
                this.worldIDs.add(id);
            }
        }
    }

    public void removeCategory(int id) {
        if (this.categories.size() == 1) {
            return;
        }
        TransportCategory cat = this.categories.get(id);
        if (cat == null) {
            return;
        }
        for (int i : cat.locations.keySet()) {
            this.locations.remove(i);
        }
        this.categories.remove(id);
        this.saveCategories();
    }

    public TransportLocation removeLocation(int location) {
        TransportLocation loc = this.locations.get(location);
        if (loc == null) {
            return null;
        }
        loc.category.locations.remove(location);
        this.locations.remove(location);
        this.saveCategories();
        return loc;
    }

    private void saveCategories() {
        CustomNpcs.debugData.start(null);
        try {
            File saveDir = CustomNpcs.getWorldSaveDirectory();
            File file = new File(saveDir, "transport.dat_new");
            File file2 = new File(saveDir, "transport.dat_old");
            File file3 = new File(saveDir, "transport.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.getNBT(), (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        CustomNpcs.debugData.end(null);
    }

    public void saveCategory(NBTTagCompound compound) {
        int id = compound.func_74762_e("CategoryId");
        if (id < 0) {
            id = this.getUniqueIdCategory();
        }
        if (this.categories.containsKey(id)) {
            this.categories.get(id).readNBT(compound);
            if (CustomNpcs.Server != null) {
                for (int locID : this.categories.get((Object)Integer.valueOf((int)id)).locations.keySet()) {
                    WorldServer w;
                    Entity entity;
                    TransportLocation loc = this.categories.get((Object)Integer.valueOf((int)id)).locations.get(locID);
                    if (loc.npc == null || !((entity = (w = CustomNpcs.Server.func_71218_a(loc.dimension)).func_175733_a(loc.npc)) instanceof EntityNPCInterface) || !(((EntityNPCInterface)entity).advanced.roleInterface instanceof RoleTransporter) || ((RoleTransporter)((EntityNPCInterface)entity).advanced.roleInterface).transportId != locID || ((RoleTransporter)((EntityNPCInterface)entity).advanced.roleInterface).name.equals(loc.name)) continue;
                    ((RoleTransporter)((EntityNPCInterface)entity).advanced.roleInterface).name = loc.name;
                }
            }
        } else {
            TransportCategory category = new TransportCategory();
            category.readNBT(compound);
            category.id = id;
            this.categories.put(id, category);
        }
        this.saveCategories();
    }

    public TransportLocation saveLocation(int categoryId, NBTTagCompound compound, EntityNPCInterface npc) {
        TransportCategory category = this.categories.get(categoryId);
        if (category == null || !(npc.advanced.roleInterface instanceof RoleTransporter)) {
            return null;
        }
        RoleTransporter role = (RoleTransporter)npc.advanced.roleInterface;
        TransportLocation location = new TransportLocation();
        location.readNBT(compound);
        location.category = category;
        if (role.hasTransport()) {
            location.id = role.transportId;
        }
        if (location.id < 0 || !this.locations.get((Object)Integer.valueOf((int)location.id)).name.equals(location.name)) {
            while (this.containsLocationName(location.name)) {
                location.name = location.name + "_";
            }
        }
        if (location.id < 0) {
            location.id = this.getUniqueIdLocation();
        }
        category.locations.put(location.id, location);
        this.locations.put(location.id, location);
        this.saveCategories();
        return location;
    }

    public void setLocation(TransportLocation location) {
        if (this.locations.containsKey(location.id)) {
            for (TransportCategory cat : this.categories.values()) {
                cat.locations.remove(location.id);
            }
        }
        this.locations.put(location.id, location);
        location.category.locations.put(location.id, location);
    }
}

